package NewsrcLock;

$NewsrcLock::VERSION = 1.07;

use News::Newsrc 1.07;
use Fcntl qw(:flock);

@ISA = qw(News::Newsrc);

sub load
{
    my($newsrc, $file) = @_;
    
    $file or $file = "$ENV{HOME}/.newsrc";
    $newsrc->{file } = $file;
    $newsrc->{group} = { };
    $newsrc->{list } = [ ];
    
    open(NEWSRC, $file) or return '';
	1 until flock(NEWSRC, LOCK_SH);        # lock the file for reading
    my $lines = [ <NEWSRC> ];              # read the whole file
	flock(NEWSRC, LOCK_UN);                # unlock the file
    close(NEWSRC);
    
    eval { $newsrc->import_rc($lines) };
    $@ and die "NewsrcLock::load: file $file: $@";

    1
}

sub save_as
{
    my($newsrc, $file) = @_;
    
    $newsrc->{file} = $file;
	# We have to use News::Newsrc::NEWSRC to make $newsrc->format work.
    open(News::Newsrc::NEWSRC, "> $file") or 
		die "NewsrcLock::save_as: Can't open $file: $!\n";
	1 until flock(News::Newsrc::NEWSRC, LOCK_EX); # lock the file for writing
    eval { $newsrc->format($file) };               # write the entire file
	flock(News::Newsrc::NEWSRC, LOCK_UN);         # unlock the file
    close News::Newsrc::NEWSRC;
    die $@ if $@;
}

1;
