#! /usr/bin/perl

###########################################################################
# Load configuration from this file:
do '/users/brg/.www/webnews/webnews.conf';
# ALL OTHER CONFIGURATION CHANGES SHOULD BE MADE IN THE ABOVE-NAMED FILE.
###########################################################################

###########################################################################
# You shouldn't have to change these:
# Name of the local copy of the active file, located in WNDIR.
$ACTIVE = 'active.txt';

# User-Agent header used when posting to newsgroups: 
$USER_AGENT = 'WebNews';

# By default, we trust the username the web server tells us.
$USER = $ENV{'REMOTE_USER'};
###########################################################################

###########################################################################
# Set up the modules we use:
use News::NNTPClient;
use News::Newsrc;
use Net::SMTP;
use Set::IntSpan;
use CGI;
use Text::Wrap;
use HTTP::Date;
###########################################################################

###########################################################################
# Squash some warnings.
use vars qw($SPAMFILTER $WNDIR $MAILHOST);
###########################################################################

###########################################################################
# Some CGI preliminaries.
$query = new CGI;
print $query->header;
print $query->start_html(-title=>"WebNews", -bgcolor=>'#FFFFFF');
print "<IMG SRC=\"${BASEURL}images/webnews.png\" BORDER=0><BR>\n";

# Force our errors to be printed into the web page.
$| = 1;
open(STDERR, ">&STDOUT") or die "Couldn't redirect std. err\n";
###########################################################################

###########################################################################
# Set up for the user who called us:
if ($query->param('user')) { $USER = $query->param('user'); }
if (! $USER) {
	print "I can't figure out what your username is. Sorry!\n";
	print signature();
	exit 0;
}
$USERDIR = "$WNDIR/users/$USER";
$NEWSRC = "$USERDIR/newsrc";

# We may have a new user here. Make a new userdir and/or newsrc if so.
if (! -d $USERDIR) {
	mkdir $USERDIR, 0755;
}
if (! -f $NEWSRC) {
	open(NEWSRC,">$NEWSRC") or die "Can't write $NEWSRC: $!\n";
	print NEWSRC "news.announce.newusers: \n";
	close NEWSRC;
}
###########################################################################

###########################################################################
# Fix up inputs:
foreach $imageinput ('subscribe', 'Submit', 'chgsubscriptions') {
	if ($query->param("${imageinput}.x") || $query->param("${imageinput}.y")) {
		$query->delete("${imageinput}.x");
		$query->delete("${imageinput}.y");
		$query->param("${imageinput}", 'true');
	}
}
if ($query->param("Submit")) {
	$query->delete("Submit");
	$query->param("submit", "true");
}
###########################################################################

###########################################################################
# Connect to news server:
$nntp = new News::NNTPClient($SERVER) or die "Couldn't connect to news server $SERVER ($!); please try again later.";
$newsrc = new News::Newsrc;
$newsrc->load($NEWSRC) or die "Couldn't load $NEWSRC: $!";
###########################################################################

###########################################################################
# Read in (and, if necessary, update) local copy of news active file:
if (! -f $ACTIVE) {
	open(ACTIVE, ">$ACTIVE") or die "Can't write active file: $!\n";
	@active = $nntp->list('active');
	print ACTIVE $nntp->list('active');
	close ACTIVE;
} else {
	my $since = (stat($ACTIVE))[9];
	open(ACTIVE, ">>$ACTIVE") or die "Can't write active file: $!\n";
	print ACTIVE $nntp->newgroups($since);
	close ACTIVE;
	open(ACTIVE, "$ACTIVE") or die "Can't read active file: $!\n";
	@active = <ACTIVE>;
	close ACTIVE;
}
@groups = map { my $a = $_; $a =~ s/\s+.*$//; chomp $a; $a; } @active;
###########################################################################

#sub hierarchy {
#	sub hier1 {
#		if ($_[0] =~ /(.*)\.([^.]*)$/) {
#			return (hier1($1), "$1.$2");
#		} else {
#			return $_[0];
#		}
#	}
#	my $a = shift or return ();
#	$a =~ s/(.*)\.([^.]*)$/$1/;
#	my @rawlist = (hier1($a), hierarchy(@_));
#	my %unique_hierarchies;
#	foreach my $grp (@rawlist) { $unique_hierarchies{$grp}++; }
#	return keys %unique_hierarchies;
#}
#@hierarchies = hierarchy(@groups);

###########################################################################
# Main dispatch tree:
if ($query->param('group')) {
	if ($query->param('unsubscribe')) {
		do_unsubscribe($query->param('group'));
	} elsif ($query->param('subscribe')) {
		do_subscribe($query->param('group'));
	} elsif ($query->param('catchup')) {
		do_catchup($query->param('group'));
	} elsif ($query->param('submit')) {
		do_submit($query->param('group'), $query->param('article'));
	} elsif ($query->param('post')) {
		do_post($query->param('group'));
	} elsif ($query->param('article')) {
		if ($query->param('reply')) {
			do_reply($query->param('group'), $query->param('article'));
		} else {
			do_article($query->param('group'), $query->param('article'));
		}
	} else {
		do_group($query->param('group'));
	}
} elsif ($query->param('chgsubscriptions')) {
	do_chgsubscriptions();
} else {
	do_groupindex();
}
###########################################################################

$subscribed_to = '';

sub start_headers {
	return "<TABLE BORDER=0>\n";
}

sub end_headers {
	return "</TABLE><P>\n";
}

sub print_header {
	my ($field, $contents) = @_;
	#print "<B>${field}</B>${contents}<BR>\n";
	$contents = entitize($contents);
	print "<TR><TD ALIGN=RIGHT><B>${field}</B></TD><TD ALIGN=LEFT>${contents}</TD></TR>\n"
}

sub maybe_print_header {
	my ($field, $contents) = @_;
	print_header($field, $contents) if $field =~
		/^(From|Newsgroups|Subject|Date|Organization|Distribution)/io;
}

sub fetch_article {
	my ($nntp, $group, $article) = @_;
	$nntp->group($group);
	$newsrc->mark($group, $article);
	return $nntp->article($article);
}

sub artindex {
	my ($group) = @_;
	$query->delete('article');
	$query->param('group', $group);
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/artindex.png\" ALT=\"[Article index]\"></A> \n";
}

sub grpindex {
	$query->delete('article');
	$query->delete('group');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/grpindex.png\" ALT=\"[Group index]\"></A>\n";
}

sub unsubscribe {
	my ($group) = @_;
	$query->param('group', $group);
	$query->param('unsubscribe', 'true');
	my $selfurl = $query->self_url;
	$query->delete('unsubscribe');
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/unsubscribe.png\" ALT=\"[Unsubscribe]\"></A>\n";
}

sub briefhdrs {
	my ($group, $article) = @_;
	my ($oldhdrs);
	$query->param('group', $group);
	$query->param('article', $article);
	$oldhdrs = $query->param('headers');
	$query->param('headers', 'brief');
	my $selfurl = $query->self_url;
	$query->param('headers', $oldhdrs);
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/briefhdrs.png\" ALT=\"[Brief headers]\"></A>\n";
}

sub fullhdrs {
	my ($group, $article) = @_;
	my ($oldhdrs);
	$query->param('group', $group);
	$query->param('article', $article);
	$oldhdrs = $query->param('headers');
	$query->param('headers', 'full');
	my $selfurl = $query->self_url;
	$query->param('headers', $oldhdrs);
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/fullhdrs.png\" ALT=\"[Full headers]\"></A>\n";
}

sub reply {
	my ($group, $article) = @_;
	$query->param('group', $group);
	$query->param('article', $article);
	$query->param('reply', 'true');
	my $selfurl = $query->self_url;
	$query->delete('reply');
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/reply.png\" ALT=\"[Reply]\"></A>\n";
}

sub returntoarticle {
	my ($group, $article) = @_;
	$query->param('group', $group);
	$query->param('article', $article);
	$query->delete('reply');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/returntoarticle.png\" ALT=\"[Return to article]\"></A>\n";
}

sub post {
	my ($group) = @_;
	$query->param('group', $group);
	$query->param('post', 'true');
	my $selfurl = $query->self_url;
	$query->delete('post');
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/postmessage.png\" ALT=\"[Post message]\"></A>\n";
}

sub catchup {
	my ($group) = @_;
	$query->param('group', $group);
	$query->param('catchup', 'true');
	my $selfurl = $query->self_url;
	$query->delete('catchup');
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/catchup.png\" ALT=\"[Catch-up]\"></A>\n";
}

sub sortbynumber {
	my ($group) = @_;
	$query->param('group', $group);
	$query->delete('sortorder');
	$query->param('sortorder', 'number');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/sortbynumber.png\" ALT=\"[Sort by number]\"></A>\n";
}

sub sortbyfrom {
	my ($group) = @_;
	$query->param('group', $group);
	$query->delete('sortorder');
	$query->param('sortorder', 'from');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/sortbyfrom.png\" ALT=\"[Sort by from]\"></A>\n";
}

sub sortbysubject {
	my ($group) = @_;
	$query->param('group', $group);
	$query->delete('sortorder');
	$query->param('sortorder', 'subject');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/sortbysubject.png\" ALT=\"[Sort by subject]\"></A>\n";
}

sub sortbydate {
	my ($group) = @_;
	$query->param('group', $group);
	$query->delete('sortorder');
	$query->param('sortorder', 'date');
	my $selfurl = $query->self_url;
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/sortbydate.png\" ALT=\"[Sort by date]\"></A>\n";
}

sub gecos_name {
    my ($user) = @_;
    my ($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell,$expire)
        = getpwnam($user);
    return $user unless $gcos;
    $gcos =~ s/&/ucfirst $name/e if $gcos =~ /&/;
    $gcos =~ s/,.*$// if $gcos =~ /,/;
    return $gcos;
}

sub wrap_line {
	$Text::Wrap::columns = 80;
	return split ("\n", wrap('','', $_[0]));
}

sub wrap_message {
	my @input = @_;
	my @output;
	foreach my $line (@input) {
		if (length($line) >= 80) {
			push(@output, wrap_line($line));
		} else {
			push(@output, $line);
		}
	}
	return @output;
}

sub do_submit {
	my ($group, $article) = @_;
	my ($fromaddr, $from, $newsgroups, $subject, $followup_to, $summary,
		$organization, $distro, $replyto, $cc);
	$query->delete('submit');
	$fromaddr = "$USER\@$DOMAIN";
	$fromaddr = "spamfilter\@$DOMAIN" if $SPAMFILTER;
	$from = "$fromaddr (" . gecos_name($USER) . ")";
	$wordwrap = $query->param('wordwrap'); $query->delete('wordwrap');
	$newsgroups = $query->param('newsgroups'); $query->delete('newsgroups');
	$subject = $query->param('subject'); $query->delete('subject');
	$followup_to = $query->param('followup_to'); $query->delete('followup_to');
	$summary = $query->param('summary'); $query->delete('summary');
	$organization = $query->param('organization'); $query->delete('organization');
	$distro = $query->param('distro'); $query->delete('distro');
	$replyto = $query->param('replyto'); $query->delete('replyto');
	$cc = $query->param('cc'); $query->delete('cc');
	$article_body = $query->param('article_body'); $query->delete('article_body');
	$msgid = $query->param('msgid'); $query->delete('msgid');
	print $query->h2("[$USER] Submitting new article to $group"), "\n";
	print grpindex();
	print artindex($group);
	print unsubscribe($group);
	print returntoarticle($group, $article);
	if (! $nntp->postok) {
		print "<P><B>Error:</B> The NNTP server $SERVER is not allowing \n";
		print "posting. Contact your system administrator for \n";
		print "more information.</P>\n";
		print signature();
		return;
	}
	if (! $subject) {
		print "<P><B>Error:</B> You failed to give a subject. Go 'back' in \n";
		print "your browser and fill one in, if you want to post your\n";
		print "message.</P>\n";
		print signature();
		return;
	}
	push(@headers, "From: $from\n");
	push(@headers, "Newsgroups: $newsgroups\n");
	push(@headers, "Subject: $subject\n") if $subject;
	push(@headers, "Followup-To: $followup_to\n") if $followup_to;
	push(@headers, "References: $msgid\n") if $msgid;
	push(@headers, "Summary: $summary\n") if $summary;
	push(@headers, "Organization: $organization\n") if $organization;
	push(@headers, "Distribution: $distro\n") if $distro;
	push(@headers, "Reply-To: $replyto\n") if $replyto;
	push(@headers, "Cc: $cc\n") if $cc;
	push(@headers, "User-Agent: $USER_AGENT\n");
	$article_body =~ s/\r//g;
	my @article_body = split(/\n/, $article_body);
	@article_body = wrap_message(@article_body) if $wordwrap eq 'true';
	$result = $nntp->post(@headers, "\n", @article_body);
	if ($result) {
		$result = $nntp->code . " " . $nntp->message;
		chomp $result;
		print "<P>Your message was posted successfully. [$result]</P>\n";
	} else {
		$result = $nntp->code . " " . $nntp->message;
		chomp $result;
		print "<P><B>Error in posting.</B> Your message was NOT sent. [$result]</P>\n";
	}
	if ($cc) {
		$smtp = Net::SMTP->new($MAILHOST);
		$smtp->mail($fromaddr);
		$smtp->to($cc);
		$smtp->data();
		$smtp->datasend(@headers, "\n", join("\n", @article_body));
		$smtp->dataend();
		$smtp->quit;
	}
	print signature();
}

sub entitize {
	my $what = $_[0];
	$what =~ s/\&/\&amp;/g;
	$what =~ s/\"/\&quot;/g;
	$what =~ s/\</\&lt;/g;
	$what =~ s/\>/\&gt;/g;
	return $what;
}

sub do_reply {
	my ($group, $article) = @_;
	my @article = fetch_article($nntp, $group, $article);
	my $i = 0;
	for (; $i < @article; $i++) {
		chomp($line = $article[$i]);
		if ($line =~ /^([^:]*:) (.*)$/) {
			($field, $contents) = ($1, $2);
			if ($field =~ /Message-ID/io) {
				$msgid = $contents;
			} elsif ($field =~ /From/io) {
				$from = $contents;
			} elsif ($field =~ /Newsgroups/io) {
				$newsgroups = $contents;
			} elsif ($field =~ /Subject/io) {
				if ($contents =~ /^Re:/io) {
					$subject = "$contents";
				} else {
					$subject = "Re: $contents";
				}
			}
		} elsif ($line =~ /^$/) {
			last;
		}
	}
	my $attribution = "In article $msgid, $from writes:\n";
	my @article_body = @article[$i..$#article];
	@article_body = map { "> $_"; } @article_body;
	unshift(@article_body, $attribution);
	my $article_body = join "", @article_body;
	$query->delete('reply');
	my $selfurl = $query->self_url;
	
	print $query->h2("[$USER] Reply to article $article in $group"), "\n";
	print "<FORM METHOD=POST ACTION=\"$selfurl\">\n";
	return do_postingform("REPLY", $group, $article, $USER, $msgid,
		$newsgroups, $subject, $DEFAULT_ORG, $DEFAULT_DISTRO,
		$article_body);
}


sub do_post {
	my ($group) = @_;
	$query->delete('post');
	$query->param('group', $group);
	my $selfurl = $query->self_url;

	print $query->h2("[$USER] Post new message to $group"), "\n";
	print "<FORM METHOD=POST ACTION=\"$selfurl\">\n";
	return do_postingform("POST", $group, 0, $USER, "",
		$group, "", $DEFAULT_ORG, $DEFAULT_DISTRO, "");
}

sub do_postingform {
	my ($mode, $group, $article, $user, $msgid,
		$newsgroups, $subject, $org, $distro,
		$article_body) = @_;
	print grpindex();
	print artindex($group);
	print unsubscribe($group);
	if ($mode eq 'REPLY') {
		print returntoarticle($group, $article);
		print "<INPUT TYPE=\"hidden\" NAME=\"article\" VALUE=\"$article\">\n";
		print "<INPUT TYPE=\"hidden\" NAME=\"msgid\" VALUE=\"$msgid\">\n";
	}

	print "<INPUT TYPE=\"hidden\" NAME=\"group\" VALUE=\"$group\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"user\" VALUE=\"$USER\">\n";
	print "<INPUT TYPE=\"image\" SRC=\"${BASEURL}images/submit.png\" ALT=\"[Submit]\" NAME=\"Submit\" VALUE=\"true\">";

	print "<P>(If you wish to cancel posting, ";
	print "click <B>Return to Article</B> to go back to what you were" .
		" reading, " if $mode eq 'REPLY';
	print "click <B>Article Index</B> to read more articles from this group, ";
	print "or click <B>Group Index</B> to choose a different group.)</P>\n";

	print "<TABLE>\n";
	print "<TR><TD ALIGN=RIGHT>Newsgroups:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"newsgroups\" VALUE=\"$newsgroups\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Subject:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"subject\" VALUE=\"$subject\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Followup-To:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"followup_to\" VALUE=\"$newsgroups\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Summary:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"summary\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Organization:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"organization\" VALUE=\"$DEFAULT_ORG\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Distribution:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"distro\" VALUE=\"$DEFAULT_DISTRO\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Reply-To:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"replyto\">",
	"</TD></TR>\n";
	print "<TR><TD ALIGN=RIGHT>Cc:</TD><TD ALIGN=LEFT>", 
	"<INPUT TYPE=\"text\" SIZE=70 NAME=\"cc\">",
	"</TD></TR>\n";
	print "</TABLE>\n";
	print "<HR>\n";
	print $query->checkbox(-name=>'wordwrap', -checked=>'yes',
		-value=>'true', -label=>'Auto-fill to 80 columns');
	print "<BR>\n<TEXTAREA COLS=80 ROWS=24 NAME=\"article_body\">\n";
	$article_body = entitize($article_body);
	print "$article_body\n";
	print "</TEXTAREA>";
	print "</FORM><P>";
	print signature();
}

sub do_catchup {
	my ($group) = @_;
	my $got_params = ($query->param('catchup_from')) ? 1 : 0;
	my $catchup_from = $query->param('catchup_from');
	my $catchup_to = $query->param('catchup_to');
	$query->delete('submit');
	$query->delete('catchup');
	$query->delete('catchup_from');
	$query->delete('catchup_to');
	my $selfurl = $query->self_url;

	if ($got_params) {
		$newsrc->mark_range($group, $catchup_from, $catchup_to);
		return do_group($group);
	}

	print "<FORM METHOD=GET ACTION=\"$selfurl\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"group\" VALUE=\"$group\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"user\" VALUE=\"$USER\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"catchup\" VALUE=\"true\">\n";
	print grpindex();
	print artindex($group);
	print unsubscribe($group);
	print "<INPUT TYPE=\"image\" SRC=\"${BASEURL}images/submit.png\" ALT=\"[Submit]\" NAME=\"Submit\" VALUE=\"true\">";


	print $query->h2("[$USER] Catch-up articles in $group"), "\n";
	
	print "<P>Click <B>Submit</B>, above, if you would like to mark \n";
	print "<B>ALL</B> articles in the group as read. Otherwise, you can \n";
	print "modify the range of article numbers to mark as read. \n";
	print "Just hit <B>Article Index</B> if you want to cancel.</P>\n";

	my ($first, $last) = $nntp->group($group);

	print "<P>Mark articles from: \n";
	print $query->textfield(-name=>'catchup_from', -default=>"$first",
		-size=>10);
	print " to: \n";
	print $query->textfield(-name=>'catchup_to', -default=>"$last",
		-size=>10);
	print " as read.</P>\n";

	print "</FORM>\n";

	print signature();
}

sub do_article {
	my ($group, $article) = @_;
	my @article = fetch_article($nntp, $group, $article);
	my $i = 0;
	my $selfurl = $query->url(-absolute);

	print $query->h2("[$USER] Article number $article in $group"), "\n";
	$full_headers = (($query->param('headers') eq 'full') ? 1 : 0);
	$query->delete('headers');
	print grpindex();
	print artindex($group);
	print unsubscribe($group);
	print reply($group, $article);
	if ($full_headers) {
		print briefhdrs($group,$article);
	} else {
		print fullhdrs($group,$article);
	}
	print "<HR>";
	print start_headers();
	for (; $i < @article; $i++) {
		chomp($line = $article[$i]);
		if ($line =~ /^([^:]*:)( .*)$/) {
			if ($full_headers) {
				print_header($1, $2);
			} else {
				maybe_print_header($1, $2);
			}
		} elsif ($line =~ /^$/) {
			last;
		} else { 
			print "$line\n";
		}
	}

	print end_headers();
	print "<PRE>";
	for (; $i < @article; $i++) {
		print entitize($article[$i]);
	}
	print "</PRE><P>\n";
	print signature();
}

sub xover_sort_by_subject {
	local ($anumb,$asubj,$afrom,$adate,$amesg,$arefr,$achar,$aline,$axref) 
		= split(/\t/, $a);
	local ($bnumb,$bsubj,$bfrom,$bdate,$bmesg,$brefr,$bchar,$bline,$bxref) 
		= split(/\t/, $b);
	1 while $asubj =~ s/^Re(:|-)?\s*//g;
	1 while $bsubj =~ s/^Re(:|-)?\s*//g;
	local ($sortorder) = (uc($asubj) cmp uc($bsubj));
	return $sortorder ? $sortorder : ($anumb <=> $bnumb);
}

sub xover_sort_by_from {
	local ($anumb,$asubj,$afrom,$adate,$amesg,$arefr,$achar,$aline,$axref) 
		= split(/\t/, $a);
	local ($bnumb,$bsubj,$bfrom,$bdate,$bmesg,$brefr,$bchar,$bline,$bxref) 
		= split(/\t/, $b);
	$afrom =~ s/\"//g;
	$bfrom =~ s/\"//g;
	local ($sortorder) = (uc($afrom) cmp uc($bfrom));
	return $sortorder ? $sortorder : ($anumb <=> $bnumb);
}

sub xover_sort_by_date {
	local ($anumb,$asubj,$afrom,$adate,$amesg,$arefr,$achar,$aline,$axref) 
		= split(/\t/, $a);
	local ($bnumb,$bsubj,$bfrom,$bdate,$bmesg,$brefr,$bchar,$bline,$bxref) 
		= split(/\t/, $b);
	local ($sortorder) = (str2time($adate) <=> str2time($bdate));
	return $sortorder ? $sortorder : ($anumb <=> $bnumb);
}

sub xover_sort_by_number {
	local ($anumb,$asubj,$afrom,$adate,$amesg,$arefr,$achar,$aline,$axref) 
		= split(/\t/, $a);
	local ($bnumb,$bsubj,$bfrom,$bdate,$bmesg,$brefr,$bchar,$bline,$bxref) 
		= split(/\t/, $b);
	return ($anumb <=> $bnumb);
}

sub xover_sort {
	my ($sort_order, @xover) = @_;
	$sort_order = "xover_sort_by_$sort_order";
	return sort $sort_order @xover;
}

sub do_group {
	my ($group) = @_;
	my ($sortorder) = 'number';
	my (@rows);
	my ($readarticles, $serverhas, $newarticles);

	print $query->h2("[$USER] Article index for $group"), "\n";
	print grpindex();
	print unsubscribe($group);
	print post($group);
	print catchup($group);

	if ($query->param('sortorder')) {
		$sortorder = $query->param('sortorder');
	}

	print "<p>(When you're done with this group, please click on ";
	print "<B>Group Index</B>\n";
	print "to select another.)</p>\n";

	$readarticles = Set::IntSpan->new(scalar $newsrc->marked_articles($group));
	$serverhas = Set::IntSpan->new(scalar $nntp->group($group));
	$newarticles = $serverhas->diff($readarticles);

	# numb subj from date mesg refr char line xref
	@xover = $nntp->xover($serverhas->run_list);
	print "<TABLE>";
    print "<TR BGCOLOR=#999999><TH>Number<BR>", sortbynumber($group),"</TH><TH>From<BR>", sortbyfrom($group), "</TH><TH>Subject<BR>", sortbysubject($group), "</TH><TH>Date<BR>", sortbydate($group), "</TH></TR>\n";
	foreach my $hdr (xover_sort($sortorder, @xover)) {
		my (@hdr) = split(/\t/, $hdr);
		my ($numb,$subj,$from,$date,$mesg,$refr,$char,$line,$xref) = @hdr;
		$query->param('group',$group);
		$query->param('article',$numb);
		my $selfurl = $query->self_url;
		$numb = "<A HREF=\"$selfurl\">"
			. ($newarticles->member($numb) ? "<B>" : "")
			. $numb
			. ($newarticles->member($numb) ? "</B>" : "")
			. "</A>";
		$from =~ s/\"//g;
		$date = time2str(str2time($date));
		print $query->Tr($query->td([$numb,$from,$subj,$date]));
	}
	print "</TABLE>";
	print "<P>";
	print signature();
}

sub signature {
    return "<HR><ADDRESS>root\@cory.EECS.Berkeley.EDU</ADDRESS>\n";
}

sub do_unsubscribe {
	my ($group) = @_;
	$subscribed_to = 'unsubscribed from';
	$newsrc->unsubscribe($group);
	$query->delete('unsubscribe');
	do_groupindex();
}

sub chgsubscriptions {
	$query->param('chgsubscriptions', 'true');
	$query->delete('group');
	my $selfurl = $query->self_url;
	$query->delete('chgsubscriptions');
	return "<A HREF=\"$selfurl\"><IMG SRC=\"${BASEURL}images/chgsubscriptions.png\" ALT=\"[Change subscriptions]\" ALIGN=absmiddle></A>";
}

sub do_chgsubscriptions {
	my $subs = $query->param('subs');
	my @unsubs = $query->param('unsubs');
	my $selfurl = $query->self_url;
	$query->delete('subs');
	$query->delete('unsubs');
	$query->delete('chgsubscriptions');
	print $query->h2("[$USER] Change subscriptions"), "\n";
	print "<FORM METHOD=\"POST\" ACTION=\"$selfurl\">\n";
	print grpindex();
	print "<INPUT TYPE=\"hidden\" NAME=\"chgsubscriptions\" VALUE=\"true\">\n";
	print "<INPUT TYPE=\"hidden\" NAME=\"user\" VALUE=\"$USER\">\n";
	print "<INPUT TYPE=\"image\" SRC=\"${BASEURL}images/submit.png\" ALT=\"[Submit]\" NAME=\"chgsubscriptions\" VALUE=\"true\"><BR>";
	if ($subs || @unsubs) {
		print "<BR><H3>THE FOLLOWING UPDATES TO YOUR SUBSCRIPTIONS HAVE BEEN MADE:</H3><P>";
	}
	if ($subs) {
		my @subs = split(/\n/, $subs);
		foreach my $g (@subs) {
			$g =~ s/^\s*//; $g =~ s/\s*$//;
			if ($g =~ /^([^:!]*)([:!]) ([0-9,\-]*)$/) {
				my ($ng, $su, $al) = ($1, $2, $3);
				if (! grep {$_ eq $ng;} @groups) {
					print "<B>Can't use group $ng because the server doesn't have it.</B><BR>\n";
				} else {
					if (! $newsrc->exists($ng)) { $newsrc->add_group($ng) }
					if ($su eq ":") {
						$newsrc->subscribe($ng);
					} elsif ($su eq "!") {
						$newsrc->unsubscribe($ng);
					}
					$newsrc->set_articles($ng, $al);
					print "<B>Imported <CODE>.newsrc</CODE> line: $g</B><BR>\n";
				}
			} else {
				if (! grep {$_ eq $g;} @groups) {
					print "<B>Can't find $g in the list of active newsgroups</B><BR>\n";
				} else {
					if (! $newsrc->exists($g)) {
						if (! $newsrc->add_group($g)) {
							print "<B>Failed to add $g to your newsgroup list.</B><BR>\n";
							# newsgroups are added in a subscribed state,
							# so we are done.
						} else {
							print "<B>You have been subscribed to $g.</B><BR>\n";
						}
					} elsif ($newsrc->subscribed($g)) {
						print "<B>Can't subscribe to a group you are already subscribed to [$g].</B><BR>\n";
					} elsif ($newsrc->subscribe($g)) {
						print "<B>You have been subscribed to $g.</B><BR>\n";
					} else {
						print "<B>Failed to subscribe to $g.</B><BR>\n";
					}
				}
			}
		}
	}
	if (@unsubs) {
		foreach my $g (@unsubs) {
			if (! $g) {
				print "<B>Can't unsubscribe from an empty group name.</B><BR>\n";
			} elsif (! $newsrc->subscribed($g)) {
				print "<B>Can't unsubscribe from a group you are not already subscribed to [$g].</B><BR>\n";
			} else {
				$newsrc->unsubscribe($g);
			}
			unless ($newsrc->subscribed($g)) {
				print "<B>You have been unsubscribed from $g.</B><BR>\n";
			} else {
				print "<B>Failed to unsubscribe from $g.</B><BR>\n";
			}
		}
	}
	print "<p>(When you're done here, click <b>Group Index</b> to go ";
	print "back to the list of newsgroups you've subscribed to.)</p>";
	print "<H3>SUBSCRIBING (<A HREF=\"#unsub\">SEE BELOW FOR UNSUBSCRIBING</A>)</H3>\n";
	print "<P>You may browse the list of active newsgroups ";
	print "<A HREF=\"${BASEURL}${ACTIVE}\">here</A>, but be warned, ";
	print "it's very long (currently ", int((stat $ACTIVE)[7] / 1024);
	print " kilobytes).</P>\n";
	print "<P>Subscribe to groups by typing their names in here, then\n";
	print "click <B>Submit</B>. You may specify one newsgroup on each line.\n";
	print "Alternatively, you may paste your <CODE>.newsrc</CODE>\n";
	print "in this box.</P>\n";
	print "<TEXTAREA COLS=80 ROWS=12 NAME=\"subs\">\n";
	print "</TEXTAREA>";
	print "<A NAME=\"unsub\"><H3>UNSUBSCRIBING</H3></A>\n";
	print "<P>Click the checkbox next to the group name to unsubscribe ";
	print "from that group. When you have checked all the groups you ";
	print "wish to unsubscribe from, click <B>Submit</B>, above. </P>\n";
	my @groups = $newsrc->sub_groups;
	my %labels;
	foreach (@groups) { $labels{$_} = "Unsubscribe from $_"; }
	print $query->checkbox_group(-name=>'unsubs', -values=>\@groups,
		-labels=>\%labels, -linebreak=>'true');
	print signature();
}

sub do_groupindex {
	print $query->h2("[$USER] Group index"), "\n";
	print chgsubscriptions();
	if ($subscribed_to) {
		my $group = $query->param('group');
		print "You have been $subscribed_to $group.<BR>\n";
	}
	my @sub_groups = $newsrc->sub_groups;
	print "<BR>\n";
	if ($#sub_groups >= 0) {
		print "\n<P>Your ", $#sub_groups + 1, " current subscription",
			($#sub_groups ? "s" : "") , ":</P>\n";
		print "<P>\n";
		foreach my $group (@sub_groups) {
			my ($readarticles, $serverhas, $newarticles);
			$query->param('group',$group);
			$selfurl = $query->self_url;
			print "<A HREF=\"$selfurl\">$group</A>: ";
			$readarticles = Set::IntSpan->new(scalar $newsrc->marked_articles($group));
			$serverhas = scalar $nntp->group($group);
			if (! $serverhas) {
				$newsrc->del_group($group);
				print "<BR><B>Removed group $group from your subscriptions, because the server doesn't have it.</B><BR>\n";
			}
			$serverhas = Set::IntSpan->new($serverhas);
			print $serverhas->cardinality, " articles";
			$newarticles = $serverhas->diff($readarticles);
			print ", <B>", $newarticles->cardinality, " unread</B>"
				if (! $newarticles->empty);
			print ".<BR>\n";
		}
		print "</P>\n";
	} else {
		print "<P><B>You are not currently subscribed to any groups.</B>\n";
		print "If you wish to subscribe to some newsgroups, click on\n";
		print "<B>Change Subscriptions</B>, above.</P>\n";
	}
	print signature();
}

$newsrc->save;
$nntp->quit;

print $query->end_html;

exit 0;
